//=============================================================================

/*:
 * @plugindesc アクターコマンド決定後、前のアクターが未行動の場合に選択を戻します。
 * 
 * @author LefTonbo
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_BattleCommandFixNext = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// BattleManager
//=============================================================================

var _BattleManager_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
  _BattleManager_initMembers.call(this);
  this._nextCommandIsManual = false;
  this._forcedBackToUndecided = false;
  this._confirmWindow = false;
  this._commandConfirmed = false;
};

var _BattleManager_startTurn = BattleManager.startTurn;
BattleManager.startTurn = function() {
  if (!this.checkAllActorDecided()) {
    return false;
  }
  if (!this._commandConfirmed) {
    this._confirmWindow = true;
    return false;
  }
  this._confirmWindow = false;
  this._commandConfirmed = false;
  _BattleManager_startTurn.call(this);
}

BattleManager.checkAllActorDecided = function() {
  for (var i = 0 ; i < $gameParty.size() ; i ++) {
    this._actorIndex = i;
    if (this.actor() && this.actor().canInput() && !this.actor().currentAction().isValid()) {
      this._actorIndex = -1;
      this.changeActor(i, 'waiting');
      this._forcedBackToUndecided = true;
      return false;
    }
  }
  this._actorIndex = $gameParty.size();
  this._forcedBackToUndecided = false;
  return true;
}

var _BattleManager_selectNextCommand = BattleManager.selectNextCommand;
BattleManager.selectNextCommand = function() {
  if (this._nextCommandIsManual) {
    this._forcedBackToUndecided = false;
    return _BattleManager_selectNextCommand.call(this);
  }
  if (this._forcedBackToUndecided) {
    this.changeActor(-1, 'waiting');
    return this.startTurn();
  }
  _BattleManager_selectNextCommand.call(this);
};

var _BattleManager_selectPreviousCommand = BattleManager.selectPreviousCommand;
BattleManager.selectPreviousCommand = function() {
  if (this._forcedBackToUndecided) {
    this._forcedBackToUndecided = false;
    this.changeActor(-1, 'undecided');
    this._actorIndex = $gameParty.size();
  }
  _BattleManager_selectPreviousCommand.call(this);
};

//=============================================================================
// Scene_Battle
//=============================================================================

var _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
  _Scene_Battle_createAllWindows.call(this);
  this.createConfirmCommandWindow();
}

Scene_Battle.prototype.createConfirmCommandWindow = function() {
  this._confirmCommandWindow = new Window_BattleConfirmCommand();
  this._confirmCommandWindow.setHandler('confirm',  this.commandStartTurn.bind(this));
  this._confirmCommandWindow.setHandler('cancel', this.commandRevertToLastActor.bind(this));
  if (Yanfly.Param.BSWLfRt) {
    this._confirmCommandWindow.setHandler('left', this.commandRevertToLastActor.bind(this));
  }
  this._confirmCommandWindow.deselect();
  this.addWindow(this._confirmCommandWindow);
};

var _Scene_Battle_changeInputWindow = Scene_Battle.prototype.changeInputWindow;
Scene_Battle.prototype.changeInputWindow = function() {
  if (BattleManager.isInputting() && BattleManager._confirmWindow) {
    this.startConfirmCommandSelection();
    return;
  }
  this._confirmCommandWindow.close();
  _Scene_Battle_changeInputWindow.call(this);
}

Scene_Battle.prototype.startConfirmCommandSelection = function() {
  this._statusWindow.deselect();
  this._actorCommandWindow.close();
  this._partyCommandWindow.close();
  this._confirmCommandWindow.setup();
};

Scene_Battle.prototype.commandStartTurn = function() {
  BattleManager._commandConfirmed = true;
  BattleManager._confirmWindow = false;
  BattleManager.startTurn();
}

Scene_Battle.prototype.commandRevertToLastActor = function() {
  BattleManager._confirmWindow = false;
  this.selectPreviousCommand();
  this.changeInputWindow();
}

var _Scene_Battle_isAnyInputWindowActive = Scene_Battle.prototype.isAnyInputWindowActive;
Scene_Battle.prototype.isAnyInputWindowActive = function() {
  if (_Scene_Battle_isAnyInputWindowActive.call(this)) {
    return true;
  }
  return this._confirmCommandWindow.active;
};

var _Scene_Battle_selectRightCommand = Scene_Battle.prototype.selectRightCommand;
Scene_Battle.prototype.selectRightCommand = function() {
  BattleManager._nextCommandIsManual = true;
  _Scene_Battle_selectRightCommand.call(this);
  BattleManager._nextCommandIsManual = false;
};

//=============================================================================
// Window_BattleConfirmCommand
//=============================================================================

function Window_BattleConfirmCommand() {
  this.initialize.apply(this, arguments);
}

Window_BattleConfirmCommand.prototype = Object.create(Window_Command.prototype);
Window_BattleConfirmCommand.prototype.constructor = Window_BattleConfirmCommand;

Window_BattleConfirmCommand.prototype.initialize = function() {
  var x = Graphics.boxWidth / 2 - this.windowWidth() / 2;
  var y = Graphics.boxHeight / 2 - this.windowHeight() / 2
  Window_Command.prototype.initialize.call(this, x, y);
  this.openness = 0;
  this.deactivate();
};

Window_BattleConfirmCommand.prototype.windowWidth = function() {
  return 192;
};

Window_BattleConfirmCommand.prototype.numVisibleRows = function() {
  return 2;
};

Window_BattleConfirmCommand.prototype.makeCommandList = function() {
  this.addCommand('行動開始', 'confirm');
  this.addCommand('戻る', 'cancel');
};

Window_BattleConfirmCommand.prototype.setup = function() {
  this.clearCommandList();
  this.makeCommandList();
  this.refresh();
  this.select(0);
  this.activate();
  this.open();
};

Window_BattleConfirmCommand.prototype.itemTextAlign = function() {
    return 'center';
};

Window_BattleConfirmCommand.prototype.processHandling = function() {
  if (this.isOpenAndActive() && Yanfly.Param.BSWPageUpDn) {
    if (this.isHandled('pageup') && Input.isRepeated('pageup')) {
      return this.processPageup();
    }
  }
  Window_Selectable.prototype.processHandling.call(this);
  if (this.isOpenAndActive() && Yanfly.Param.BSWLfRt) {
    if (this.isHandled('left') && Input.isRepeated('left')) {
      this.processLeft();
    }
  }
};

Window_BattleConfirmCommand.prototype.processLeft = function() {
  SoundManager.playCancel();
  this.updateInputData();
  this.deactivate();
  this.callHandler('left');
};

Window_BattleConfirmCommand.prototype.isOkTriggered = function() {
  return Input.isTriggered('ok');
};

//=============================================================================

})();

// EOF